<?php 
require_once "../config/Conexion.php";

Class Escritorio
{
	//Implementamos nuestro constructor
	public function __construct()
	{

	}

	//Implementar un método para listar los registros
	public function cargarGrafico()
	{
		$sql="SELECT DATE(fecha_marca) AS fecha, COUNT(id_reporte) AS total_reportes
			FROM reporte
			WHERE fecha_marca >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
			GROUP BY DATE(fecha_marca)
			ORDER BY MIN(fecha_marca) LIMIT 0, 25;";
		return ejecutarConsulta($sql);		
	}

	//Implementar un método para mostrar los datos de un registro a modificar
	public function cargarDash()
	{
    	$sql = "SELECT 
				(SELECT COUNT(id_barrio) FROM barrio) AS total_barrios,
				(SELECT COUNT(id_usuario) FROM usuario) AS total_usuarios,
				(SELECT COUNT(id_distrito) FROM distrito) AS total_distritos,
				(SELECT COUNT(id_reporte) FROM reporte) AS total_reportes,
				(SELECT COUNT(id_reporte) FROM reporte WHERE estado_reporte = 'pendiente') AS reportes_pendientes,
 				(SELECT COUNT(id_reporte) FROM reporte WHERE estado_reporte = 'atendido') AS reportes_atendidos";
    return ejecutarConsultaSimpleFila($sql);
	}
	public function cargarDashDepartamento($id_departamento)
	{
    	$sql = "SELECT 
			    -- Total de barrios en un departamento específico
			    (SELECT COUNT(b.id_barrio) 
			     FROM barrio b
			     INNER JOIN distrito d ON b.id_distrito = d.id_distrito
			     INNER JOIN provincia p ON d.id_provincia = p.id_provincia
			     WHERE p.id_departamento = $id_departamento) AS total_barrios,

			    -- Total de usuarios (sin filtro)
			    (SELECT COUNT(id_usuario) FROM usuario) AS total_usuarios,

			    -- Total de distritos en un departamento específico
			    (SELECT COUNT(d.id_distrito) 
			     FROM distrito d
			     INNER JOIN provincia p ON d.id_provincia = p.id_provincia
			     WHERE p.id_departamento = $id_departamento) AS total_distritos,

			    -- Total de reportes en un departamento específico
			    (SELECT COUNT(r.id_reporte) 
			     FROM reporte r
			     INNER JOIN barrio b ON r.id_barrio = b.id_barrio
			     INNER JOIN distrito d ON b.id_distrito = d.id_distrito
			     INNER JOIN provincia p ON d.id_provincia = p.id_provincia
			     WHERE p.id_departamento = $id_departamento) AS total_reportes,
				 (SELECT COUNT(r.id_reporte) 
				FROM reporte r
				INNER JOIN barrio b ON r.id_barrio = b.id_barrio
				INNER JOIN distrito d ON b.id_distrito = d.id_distrito
				INNER JOIN provincia p ON d.id_provincia = p.id_provincia
				WHERE r.estado_reporte = 'pendiente' AND p.id_departamento = $id_departamento) AS reportes_pendientes,
				
				-- Total de reportes atendidos en un departamento específico
				(SELECT COUNT(r.id_reporte) 
				FROM reporte r
				INNER JOIN barrio b ON r.id_barrio = b.id_barrio
				INNER JOIN distrito d ON b.id_distrito = d.id_distrito
				INNER JOIN provincia p ON d.id_provincia = p.id_provincia
				WHERE r.estado_reporte = 'atendido' AND p.id_departamento =$id_departamento) AS reportes_atendidos;
						";
    return ejecutarConsultaSimpleFila($sql);
	}

 //



	public function listarProvincias()
	{
		$sql="SELECT 
    		p.nombre_provincia,
    		COUNT(r.id_reporte) AS numero_reportes,
    		ROUND((COUNT(r.id_reporte) * 100.0 / (SELECT COUNT(*) FROM reporte)), 2) AS porcentaje
			FROM 
			    reporte r
			JOIN 
			    barrio b ON r.id_barrio = b.id_barrio
			JOIN 
			    distrito d ON b.id_distrito = d.id_distrito
			JOIN 
			    provincia p ON d.id_provincia = p.id_provincia
			GROUP BY 
			    p.id_provincia, p.nombre_provincia
			ORDER BY 
			    numero_reportes DESC;
			";
		return ejecutarConsulta($sql);		
	}
	public function listarProvinciasPorTematica($id_tematica)
	{
		$sql = "SELECT 
			p.nombre_provincia,
			COUNT(r.id_reporte) AS numero_reportes,
			ROUND((COUNT(r.id_reporte) * 100.0 / (SELECT COUNT(*) FROM reporte WHERE id_tematica = '$id_tematica')), 2) AS porcentaje
			FROM 
				reporte r
			JOIN 
				barrio b ON r.id_barrio = b.id_barrio
			JOIN 
				distrito d ON b.id_distrito = d.id_distrito
			JOIN 
				provincia p ON d.id_provincia = p.id_provincia
			WHERE 
				r.id_tematica = '$id_tematica'
			GROUP BY 
				p.id_provincia, p.nombre_provincia
			ORDER BY 
				numero_reportes DESC";
		return ejecutarConsulta($sql);
	}

	public function listarProvinciasPorDepartamento($id_departamento)
	{
    $sql = "SELECT 
        	p.nombre_provincia,
        	COUNT(r.id_reporte) AS numero_reportes,
        	ROUND((COUNT(r.id_reporte) * 100.0 / (SELECT COUNT(*) 
            FROM reporte r
            JOIN barrio b ON r.id_barrio = b.id_barrio
            JOIN distrito d ON b.id_distrito = d.id_distrito
            JOIN provincia p ON d.id_provincia = p.id_provincia
            WHERE p.id_departamento = '$id_departamento')), 2) AS porcentaje
			FROM 
				reporte r
			JOIN 
				barrio b ON r.id_barrio = b.id_barrio
			JOIN 
				distrito d ON b.id_distrito = d.id_distrito
			JOIN 
				provincia p ON d.id_provincia = p.id_provincia
			WHERE 
				p.id_departamento = '$id_departamento'
			GROUP BY 
				p.id_provincia, p.nombre_provincia
			ORDER BY 
				numero_reportes DESC";
			
			return ejecutarConsulta($sql);
	}

	public function listarProvinciasPorDepartamentoYTematica($id_departamento, $id_tematica)
{
    $sql = "SELECT 
        	p.nombre_provincia,
        	COUNT(r.id_reporte) AS numero_reportes,
        	ROUND((COUNT(r.id_reporte) * 100.0 / (SELECT COUNT(*) 
            FROM reporte r
            JOIN barrio b ON r.id_barrio = b.id_barrio
            JOIN distrito d ON b.id_distrito = d.id_distrito
            JOIN provincia p ON d.id_provincia = p.id_provincia
            WHERE p.id_departamento = '$id_departamento'
            AND r.id_tematica = '$id_tematica')), 2) AS porcentaje
			FROM 
				reporte r
			JOIN 
				barrio b ON r.id_barrio = b.id_barrio
			JOIN 
				distrito d ON b.id_distrito = d.id_distrito
			JOIN 
				provincia p ON d.id_provincia = p.id_provincia
			WHERE 
				p.id_departamento = '$id_departamento'
				AND r.id_tematica = '$id_tematica'
			GROUP BY 
				p.id_provincia, p.nombre_provincia
			ORDER BY 
				numero_reportes DESC";
			
			return ejecutarConsulta($sql);
		}
/*----------------------------------TEMATICA --------------------------------------------- */
	public function listarTematicas()
	{
		$sql = "SELECT 
					t.nombre_tematica,
					COUNT(r.id_reporte) AS numero_reportes,
					ROUND((COUNT(r.id_reporte) * 100.0 / (SELECT COUNT(*) FROM reporte)), 2) AS porcentaje
				FROM 
					reporte r
				JOIN 
					tematica t ON r.id_tematica = t.id_tematica
				GROUP BY 
					t.id_tematica, t.nombre_tematica
				ORDER BY 
					numero_reportes DESC";
		return ejecutarConsulta($sql);
	}	

	public function listarTematicasPorProvincia($id_provincia)
	{
		$sql = "SELECT 
					t.nombre_tematica,
					COUNT(r.id_reporte) AS numero_reportes,
					ROUND((COUNT(r.id_reporte) * 100.0 / (SELECT COUNT(*) 
						FROM reporte r
						JOIN barrio b ON r.id_barrio = b.id_barrio
						JOIN distrito d ON b.id_distrito = d.id_distrito
						JOIN provincia p ON d.id_provincia = p.id_provincia
						WHERE p.id_provincia = '$id_provincia')), 2) AS porcentaje
				FROM 
					reporte r
				JOIN 
					tematica t ON r.id_tematica = t.id_tematica
				JOIN 
					barrio b ON r.id_barrio = b.id_barrio
				JOIN 
					distrito d ON b.id_distrito = d.id_distrito
				JOIN 
					provincia p ON d.id_provincia = p.id_provincia
				WHERE 
					p.id_provincia = '$id_provincia'
				GROUP BY 
					t.id_tematica, t.nombre_tematica
				ORDER BY 
					numero_reportes DESC";
		return ejecutarConsulta($sql);
	}

	public function listarTematicasPorDepartamento($id_departamento)
	{
		$sql = "SELECT 
					t.nombre_tematica,
					COUNT(r.id_reporte) AS numero_reportes,
					ROUND((COUNT(r.id_reporte) * 100.0 / (SELECT COUNT(*) 
						FROM reporte r
						JOIN barrio b ON r.id_barrio = b.id_barrio
						JOIN distrito d ON b.id_distrito = d.id_distrito
						JOIN provincia p ON d.id_provincia = p.id_provincia
						WHERE p.id_departamento = '$id_departamento')), 2) AS porcentaje
				FROM 
					reporte r
				JOIN 
					tematica t ON r.id_tematica = t.id_tematica
				JOIN 
					barrio b ON r.id_barrio = b.id_barrio
				JOIN 
					distrito d ON b.id_distrito = d.id_distrito
				JOIN 
					provincia p ON d.id_provincia = p.id_provincia
				WHERE 
					p.id_departamento = '$id_departamento'
				GROUP BY 
					t.id_tematica, t.nombre_tematica
				ORDER BY 
					numero_reportes DESC";
		return ejecutarConsulta($sql);
	}

	public function cargarMapa()
	{
		$sql="SELECT
			d.id_departamento,
			COUNT(r.id_reporte) AS numero_reportes
			FROM
				reporte r
			JOIN barrio b ON r.id_barrio = b.id_barrio
			JOIN distrito di ON b.id_distrito = di.id_distrito
			JOIN provincia p ON di.id_provincia = p.id_provincia
			JOIN departamento d ON p.id_departamento = d.id_departamento
			GROUP BY
				d.id_departamento
			ORDER BY
				numero_reportes DESC;";
		return ejecutarConsulta($sql);		
	}

	public function totalReportesDepartamento($id_departamento)
	{
    	$sql = "SELECT 

			    -- Total de reportes en un departamento específico
			 (SELECT DISTINCT de.nombre_departamento
			     FROM reporte r
			     INNER JOIN barrio b ON r.id_barrio = b.id_barrio
			     INNER JOIN distrito d ON b.id_distrito = d.id_distrito
			     INNER JOIN provincia p ON d.id_provincia = p.id_provincia
              	INNER JOIN departamento de ON de.id_departamento = p.id_departamento
			     WHERE p.id_departamento = $id_departamento) AS nombre_departamento,
			(SELECT COUNT(r.id_reporte) 
				FROM reporte r
				INNER JOIN barrio b ON r.id_barrio = b.id_barrio
				INNER JOIN distrito d ON b.id_distrito = d.id_distrito
				INNER JOIN provincia p ON d.id_provincia = p.id_provincia
				WHERE r.estado_reporte = 'pendiente' AND p.id_departamento = $id_departamento) AS reportes_pendientes,
				
				-- Total de reportes atendidos en un departamento específico
			(SELECT COUNT(r.id_reporte) 
				FROM reporte r
				INNER JOIN barrio b ON r.id_barrio = b.id_barrio
				INNER JOIN distrito d ON b.id_distrito = d.id_distrito
				INNER JOIN provincia p ON d.id_provincia = p.id_provincia
				WHERE r.estado_reporte = 'atendido' AND p.id_departamento =$id_departamento) AS reportes_atendidos;
						";
    return ejecutarConsultaSimpleFila($sql);
	}
}

?>