function init() {
  $("#cubito").validacion("0123456789");
  $("#radio").validacion("0123456789");
  $("#mc-1").validacion("0123456789");
  $("#mc-2").validacion("0123456789");
  $("#mc-3").validacion("0123456789");
  $("#mc-4").validacion("0123456789");
  $("#mc-5").validacion("0123456789");
  $("#fp-1").validacion("0123456789");
  $("#fp-2").validacion("0123456789");
  $("#fp-3").validacion("0123456789");
  $("#fp-4").validacion("0123456789");
  $("#fp-5").validacion("0123456789");
  $("#fm-2").validacion("0123456789");
  $("#fm-3").validacion("0123456789");
  $("#fm-4").validacion("0123456789");
  $("#fm-5").validacion("0123456789");
  $("#fd-1").validacion("0123456789");
  $("#fd-2").validacion("0123456789");
  $("#fd-3").validacion("0123456789");
  $("#fd-4").validacion("0123456789");
  $("#fd-5").validacion("0123456789");
  $("#id_formulario").on("submit", function (e) {
    guardaryeditar(e);
  });
}

$("#id_formulario").on("submit", function (e) {
  guardaryeditar(e);
});

function limpiar() {
  $("#nombre").val("");
  $("#telef").val("");
  $("#dni").val("");
  $("id_barrio").val("");
  $("#detalle").val("");
}

function guardaryeditar(e) {
  e.preventDefault(); // No se activará la acción predeterminada del evento (no recargará la página)
  // Obtener el formulario y sus datos
  var formData = new FormData($("#id_formulario")[0]);

  // Variable para almacenar la suma total
  let sumaTotal = 0;

  // Iterar sobre los valores del FormData
  for (let [key, value] of formData.entries()) {
    console.log(`${key}: ${value}`); // Imprime las claves y valores del formulario

    // Intentar convertir a número y sumar si es válido
    const numero = parseFloat(value);
    if (!isNaN(numero) && key !== "edad") {
      sumaTotal += numero;
    }
  }

  console.log(`Suma total de los valores numéricos: ${sumaTotal}`);
  const result = findAgeRange(sumaTotal, ranges);
  actualizarRangoEdades(result, sumaTotal);
  console.log(result);
  $("#modalCharge").modal("show");
}

function actualizarRangoEdades(resultado, suma) {
  // Validar que el resultado tenga la estructura esperada
  if (resultado && resultado.type === "found" && resultado.details) {
    const { edadMinima, finalValue } = resultado.details;

    // Nuevos cálculos para el rango de edad final
    const rangoFinal = (edadMinima + finalValue).toFixed(2); // Calcular rango base
    const rangoInferior = (parseFloat(rangoFinal) - 0.2).toFixed(2); // Restar 0.2
    const rangoSuperior = (parseFloat(rangoFinal) + 0.2).toFixed(2); // Sumar 0.2

    // Mostrar el rango final en el DOM
    document.getElementById("min-edad").textContent = rangoInferior;
    document.getElementById("max-edad").textContent = rangoSuperior;

    // Asignar los valores a los elementos del DOM
    document.getElementById("prueba-edad").textContent =
      document.getElementById("edad").value;
    //document.getElementById("min-edad").textContent = edadMinima || 0; // Asignar edad mínima
    //document.getElementById("max-edad").textContent = (edadMinima + finalValue).toFixed(1) || 0; // Calcular y asignar la edad máxima
    document.getElementById("resultado_suma").textContent = suma || 0; // Asignar suma total
  } else {
    console.error("El resultado no contiene datos válidos para las edades.");
  }
}

// Ejemplo de uso:
const resultado = {
  type: "found",
  ages: {
    minAge: 10,
    maxAge: 12.5,
  },
};

// Llamar a la función para actualizar los spans

/*
    $.ajax({
        url: "../ajax/formulario.php?op=1", // Cambia la URL según tu necesidad
        type: "POST",
        data: formData,
        contentType: false, // No se establece el tipo de contenido
        processData: false, // No se procesan los datos
        success: function(datos) {
            $('#modalCharge').modal('hide');
            // Limpia la cadena de saltos de línea y espacios en blanco
            var limpiaDatos = datos.trim();
            var mensaje = limpiaDatos.split(":");

            if (mensaje[0] == "1") {
                Swal.fire(
                    'Reporte Registrado',
                    mensaje[1],
                    'success'
                );
            } else {
                Swal.fire({
                    type: 'error',
                    title: 'Error',
                    text: mensaje[1],
                    footer: 'Verifique la información de Registro, en especial que la información no fue ingresada previamente a la Base de Datos.'
                });
            }
        },
        error: function(xhr, status, error) {
            $('#modalCharge').modal('hide');
            console.error("Ocurrió un error: " + error);
            Swal.fire({
                type: 'error',
                title: 'Error',
                text: 'Ocurrió un error al enviar el formulario. Intente nuevamente.'
            });
        }
    });
    */

function findAgeRange(num, ranges) {
  let foundRanges = [];

  // Identificar los rangos donde el número está contenido
  ranges.forEach(({ minValue, maxValue, minAge }) => {
    if (num >= minValue && num <= maxValue) {
      foundRanges.push({ minValue, maxValue, minAge });
    }
  });

  if (foundRanges.length > 0) {
    // Obtener el rango con el minValue más bajo
    const minRange = Math.min(...foundRanges.map((r) => r.minValue));

    // Identificar el rango más bajo
    const actualMinRange = foundRanges.find((r) => r.minValue === minRange);

    // Encontrar el rango con el minValue más alto
    const highestRange = foundRanges.reduce((prev, curr) =>
      curr.minValue > prev.minValue ? curr : prev
    );

    // Obtener el actualMaxRange del rango con el minValue más alto
    const actualMaxRange = highestRange.maxValue;

    // Calcular la diferencia y el porcentaje
    const rangeDifference = actualMaxRange - actualMinRange.minValue;
    const valueDifference = num - actualMinRange.minValue;
    const percentageOfRange = (valueDifference / rangeDifference) * 100;

    // Calcular el porcentaje respecto a la cantidad de rangos encontrados
    const totalRanges = foundRanges.length;
    const finalValue = (percentageOfRange / 100) * totalRanges;

    return {
      type: "found",
      details: {
        minRange: actualMinRange.minValue,
        maxRange: actualMaxRange,
        edadMinima: actualMinRange.minAge, // Edad mínima del rango con el minValue más bajo
        rangeDifference,
        valueDifference,
        percentageOfRange,
        totalRanges,
        finalValue,
      },
    };
  } else {
    return {
      type: "not_found",
      message: "El número no pertenece a ningún rango.",
    };
  }
}

// Definir los rangos con valores asociados
const ranges = [
  { minValue: 6, maxValue: 14, minAge: 10, maxAge: 10.5 },
  { minValue: 11, maxValue: 20, minAge: 11, maxAge: 11.5 },
  { minValue: 12, maxValue: 47, minAge: 12, maxAge: 12.5 },
  { minValue: 27, maxValue: 51, minAge: 13, maxAge: 13.5 },
  { minValue: 64, maxValue: 81, minAge: 14, maxAge: 14.5 },
  { minValue: 73, maxValue: 77, minAge: 15, maxAge: 15 },
  { minValue: 79, maxValue: 83, minAge: 16, maxAge: 16 },
]; //agarrar minimo de uno y maximo de otro en resultado 75-64

// Ejemplo de uso
const numberToCheck = 31; // Cambia este valor para probar diferentes casos
const result = findAgeRange(numberToCheck, ranges);

console.log(result);

/*
Casos esperados:
1. Si el número es 44 (coincide con dos rangos):
   { type: "found", ages: { minAge: 12, maxAge: 13.5 } }
2. Si el número es 7 (fuera de rango, más cercano a dos rangos):
   { type: "closest", ages: { minAge: 10, maxAge: 11.5 } }
3. Si el número está fuera de los rangos por arriba (e.g., 85):
   { type: "closest", ages: { minAge: 16, maxAge: 16 } }
4. Si el número pertenece a un único rango (e.g., 15):
   { type: "found", ages: { minAge: 15, maxAge: 15 } }
*/

init();
