
<?php 
session_start();
require_once "../model/Escritorio.php";
$escritorio=new Escritorio();
$id_departamento=isset($_POST["id_departamento"])? ($_POST["id_departamento"]):"";
$id_tematica=isset($_POST["id_tematica"])? ($_POST["id_tematica"]):"";
$id_provincia=isset($_POST["id_provincia"])? ($_POST["id_provincia"]):""; 
$departamento_1 = isset($_POST["departamento_1"])? ($_POST["departamento_1"]):"";
$departamento_2 = isset($_POST["departamento_2"])? ($_POST["departamento_2"]):"";

/*
$id_resumen=isset($_POST["id_resumen"])? ($_POST["id_resumen"]):"";
$nombre_resumen=isset($_POST["nombre_resumen"])?($_POST["nombre_resumen"]):"";
$num_resumens=isset($_POST["num_resumens"])? ($_POST["num_resumens"]):"";
$imagen=isset($_POST["imagen"])? $_POST["imagen"]:"";
*/

switch ($_GET["op"]){
	case '0':
        if(empty($id_departamento)){
            $rspta=$escritorio->cargarDash();
        }else{
            $rspta=$escritorio->cargarDashDepartamento($id_departamento);
        }
		
 		//Codificar el resultado utilizando json
 		echo json_encode($rspta);
	break;
    case '1':
		$rspta=$escritorio->obtenerDatosComparativos($departamento_1, $departamento_2);
 		// Declaramos dos arrays: uno para las etiquetas y otro para los valores
        $labels = [];
        $series = [];

        while ($reg = mysqli_fetch_assoc($rspta)) {
            // Formateamos la fecha como 'd/m' para las etiquetas
            $labels[] = date('d/m', strtotime($reg['fecha']));

            // Añadimos el total de reportes por día al array de series
            $series[] = $reg['total_reportes'];
        }

        // Creamos un array con la estructura que espera Chartist
        $results = array(
            "labels" => $labels,
            "series" => array($series) // Chartist espera un array multidimensional para las series
        );

        echo json_encode($results);
	break;
    case '3':
        if (empty($id_tematica) && empty($id_departamento)) {
            // Sin filtros, listar todo
            $rspta = $escritorio->listarProvincias();
        } elseif (!empty($id_tematica) && empty($id_departamento)) {
            // Filtro por temática
            $rspta = $escritorio->listarProvinciasPorTematica($id_tematica);
        } elseif (empty($id_tematica) && !empty($id_departamento)) {
            // Filtro por departamento
            $rspta = $escritorio->listarProvinciasPorDepartamento($id_departamento);
        } else {
            // Ambos filtros
            $rspta = $escritorio->listarProvinciasPorDepartamentoYTematica($id_tematica, $id_departamento);
        }
        
        // Declarar un array para almacenar los datos
        $data = array();
        
        while ($reg = mysqli_fetch_assoc($rspta)) {
            $data[] = array(
                "0" => $reg['nombre_provincia'],
                "1" => $reg['numero_reportes'],
                "2" => $reg['porcentaje'],
            );
        }
        
        // Enviar resultados a DataTables
        $results = array(
            "sEcho" => 1, // Información para DataTables
            "iTotalRecords" => count($data), // Total de registros
            "iTotalDisplayRecords" => count($data), // Total de registros visibles
            "aaData" => $data
        );
        
        echo json_encode($results);
        
    break;

    case '4':
        // Verificar los filtros recibidos (solo id_provincia y id_departamento)
        if (empty($id_provincia) && empty($id_departamento)) {
            // Sin filtros, listar todas las temáticas
            $rspta = $escritorio->listarTematicas();
        } elseif (!empty($id_departamento) && empty($id_provincia)) {
            // Filtro solo por provincia
            $rspta = $escritorio->listarTematicasPorDepartamento($id_departamento);
        } elseif (!empty($id_provincia) && empty($id_departamento)) {
            // Filtro solo por departamento
            $rspta = $escritorio->listarTematicasPorProvincia($id_provincia);
        }
    
        // Procesar los resultados de la consulta
        $labels = [];
        $series = [];

        while ($reg = mysqli_fetch_assoc($rspta)) {
            $labels[] = $reg['nombre_tematica'];  // Nombre de la temática
            $series[] = (int)$reg['numero_reportes']; // Asegurarse de que el valor sea un número entero
        }

        // Estructurar los datos para el gráfico
        $results = array(
            "labels" => $labels,  // Nombres de las temáticas
            "series" => $series  // Solo un array de valores numéricos para cada temática
        );
            
        // Enviar los resultados como JSON para el gráfico
        echo json_encode($results);
    break;
    case '5':
        $rspta = $escritorio->cargarMapa();
        $data = array();
        while ($reg = mysqli_fetch_assoc($rspta)) {
            $data[] = array(
                "id_departamento" => $reg['id_departamento'],
                "numero_reportes" => $reg['numero_reportes']
            );
        }
    
        // Establece el encabezado para JSON
        header('Content-Type: application/json');
        echo json_encode($data);
    break;
    case '6':
        // Crear el array para almacenar los resultados
        $results = [];

        // Lista de departamentos para iterar
        $departamentos = [
            "departamento_1" => $departamento_1,
            "departamento_2" => $departamento_2
        ];

        // Iterar por cada departamento
        foreach ($departamentos as $key => $departamento) {
            // 1. Obtener temáticas por departamento
            $rspta_tematicas = $escritorio->listarTematicasPorDepartamento($departamento);

            // Procesar resultados de temáticas
            $labels = [];
            $series = [];

            while ($reg = mysqli_fetch_assoc($rspta_tematicas)) {
                $labels[] = $reg['nombre_tematica'];  // Nombre de la temática
                $series[] = (int)$reg['numero_reportes']; // Convertir a número entero
            }

            // 2. Obtener provincias por departamento
            $rspta_provincias = $escritorio->listarProvinciasPorDepartamento($departamento);

            // Procesar resultados de provincias en formato de DataTables
            $data = [];
            while ($reg = mysqli_fetch_assoc($rspta_provincias)) {
                $data[] = array(
                    "0" => $reg['nombre_provincia'],    // Nombre de la provincia
                    "1" => (int)$reg['numero_reportes'], // Número de reportes
                    "2" => (float)$reg['porcentaje'],    // Porcentaje de reportes
                );
            }

            // Estructurar resultados para DataTables
            $provincias = array(
                "sEcho" => 1, // Información para DataTables
                "iTotalRecords" => count($data), // Total de registros
                "iTotalDisplayRecords" => count($data), // Total de registros visibles
                "aaData" => $data // Datos de las provincias
            );

            // 3. Obtener total de reportes por departamento
            $rspta_total_reportes = $escritorio->totalReportesDepartamento($departamento);

            // Agregar resultados al array general con clave del departamento
            $results[$key] = array(
                "tematicas" => array(
                    "labels" => $labels, // Nombres de las temáticas
                    "series" => $series  // Valores numéricos
                ),
                "provincias" => $provincias, // Información de provincias en formato de DataTables
                "total_reportes" => $rspta_total_reportes // Total de reportes
            );
        }

        // Enviar los resultados como JSON para el cliente
        echo json_encode($results);

    break;
    
    
    
    
}
?>

